clear all
clc
close all

load AAMTData

n=length(row);
Y=zeros(1,n);
for i=1:n
    Y(i)=modal{i}(1); %choose earlier action when multiple modal, should test for robustness
end

K=3;
traincount=zeros(n,3);
modaltrain=zeros(1,n);
testcount=zeros(n,3);
correct=zeros(n,3);
modaltest=zeros(1,n);
for i=1:n
    m=freq(i,4);
    t1=freq(i,1);
    t2=freq(i,1)+freq(i,2);
    
    c = cvpartition(m,'KFold',K);
    
    for k=1:K
        indtrain=find(c.training(k));
        indtest=find(c.test(k));
        
        %Train Counts
        traincount(i,1)=length(find(indtrain<=t1));
        traincount(i,2)=length(find(indtrain>t1 & indtrain<=t2));
        traincount(i,3)=length(find(indtrain>t2));
        [~,modaltrain(i)]=max(traincount(i,:));
        
        %Test Counts
        testcount(i,1)=length(find(indtest<=t1));
        testcount(i,2)=length(find(indtest>t1 & indtest<=t2));
        testcount(i,3)=length(find(indtest>t2));
        [~,modaltest(i)]=max(testcount(i,:));
        
        correct(i,k)=double(logical(modaltrain(i)==modaltest(i)));
        
        clear indtrain indtest
    end
end

mean(mean(correct))
sqrt(var(mean(correct)))